﻿//=============================================================================
// MapStairsWindow.js
//=============================================================================

var Imported = Imported || {};
Imported.MapStairsWindow = true;

/*:
 * @plugindesc マップ上で階数を表示するスクリプト
 * 
 * @help
 * プラグインコマンド:
 *
 *   MapStairsWindow show
 *     階数ウィンドウを表示する。
 *
 *   MapStairsWindow hide
 *     ウィンドウを隠す。
 *
 *   MapStairsWindow refresh
 *     ウィンドウを更新する。
 */

(function ()
{
    // プラグイン コマンド
    Game_System.prototype.isMapStairsWindowVisible = function ()
    {
        if (this._isMapStairsWindowVisible == null)
        {
            this._isMapStairsWindowVisible = false;
        }

        return this._isMapStairsWindowVisible;
    };

    Game_System.prototype.setMapStairsWindowVisible = function (value)
    {
        this._isMapStairsWindowVisible = value;
    };

    Game_System.prototype.shouldMapStairsWindowRefresh = function ()
    {
        if (this._shouldMapStairsWindowRefresh == null)
        {
            this._shouldMapStairsWindowRefresh = false;
        }

        return this._shouldMapStairsWindowRefresh;
    };

    Game_System.prototype.SetShouldMapStairsWindowRefresh = function (value)
    {
        this._shouldMapStairsWindowRefresh = value;
    };

    var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function (command, args)
    {
        _Game_Interpreter_pluginCommand.call(this, command, args);

        if (command === 'MapStairsWindow')
        {
            switch (args[0])
            {
                case 'show':
                    $gameSystem.setMapStairsWindowVisible(true);
                    break;

                case 'hide':
                    $gameSystem.setMapStairsWindowVisible(false);
                    break;

                case 'refresh':
                    $gameSystem.SetShouldMapStairsWindowRefresh(true);
                    break;
            }
        }
    };

    //-----------------------------------------------------------------------------
    // MapStairsWindow
    //
    function MapStairsWindow()
    {
        this.initialize.apply(this, arguments);
    }

    MapStairsWindow.prototype = Object.create(Window_Base.prototype);
    MapStairsWindow.prototype.constructor = MapStairsWindow;

    // 初期化
    MapStairsWindow.prototype.initialize = function ()
    {
        var x = 16;
        var y = 8;

        var wight = 96;
        var height = 64;

        Window_Base.prototype.initialize.call(this, x, y, wight, height);

        this.openness = $gameSystem.isMapStairsWindowVisible() ? 255 : 0;

        this.opacity = 255;
        this.contentsOpacity = 255;

        this.refresh();
    };

    // 行の高さ
    MapStairsWindow.prototype.lineHeight = function ()
    {
        return this._lineHeight || 36;
    };

    // デフォルトのパティング
    MapStairsWindow.prototype.standardPadding = function ()
    {
        return 0;
    };

    // 更新
    MapStairsWindow.prototype.update = function ()
    {
        Window_Base.prototype.update.call(this);

        if ($gameSystem.isMapStairsWindowVisible())
        {
            this.open();

            if ($gameSystem.shouldMapStairsWindowRefresh())
            {
                this.refresh();
            }

            if (this.x < $gamePlayer.screenX() + 24 && this.x + this._width > $gamePlayer.screenX() - 24 && this.y < $gamePlayer.screenY() && this.y + this._height > $gamePlayer.screenY() - 48)
            {
                this.opacity = 128;
            }
            else
            {
                this.opacity = 255;
            }

            this.contentsOpacity = this.opacity;
        }
        else
        {
            this.close();
        }
    };

    // リフレッシュ
    MapStairsWindow.prototype.refresh = function ()
    {
        this.contents.clear();

        this.contents.fontSize = 28;

        this.changeTextColor(this.normalColor());

        this.drawText($gameVariables.value(81) + " " + "층", 0, 14, this._width, 'center');

        $gameSystem.SetShouldMapStairsWindowRefresh(false);
    };

    // シーン マップに追加
    var _Scene_Map_createDisplayObjects = Scene_Map.prototype.createDisplayObjects;

    Scene_Map.prototype.createDisplayObjects = function ()
    {
        _Scene_Map_createDisplayObjects.call(this);

        this.createMapStairsWindow();
    };

    Scene_Map.prototype.createMapStairsWindow = function ()
    {
        this._mapStairsWindow = new MapStairsWindow();

        this.addChild(this._mapStairsWindow);
    };

    var _Scene_Map_terminate = Scene_Map.prototype.terminate;
    Scene_Map.prototype.terminate = function ()
    {
        if (!SceneManager.isNextScene(Scene_Battle))
        {
            this._mapStairsWindow.hide();
        }

        _Scene_Map_terminate.call(this);
    };

    // マップ名が中央に表示されるように変更
    var _Window_MapName_initialize = Window_MapName.prototype.initialize;
    Window_MapName.prototype.initialize = function ()
    {
        var wight = this.windowWidth();
        var height = this.windowHeight();

        if ($gameSwitches.value(4))
        {
            Window_Base.prototype.initialize.call(this, 220, 280, wight, height);
        }
        else
        {
            Window_Base.prototype.initialize.call(this, 0, 120, wight, height);
        }

        this.opacity = 0;
        this.contentsOpacity = 0;
        this._showCount = 0;
        this.refresh();
    };

    var _Window_MapName_open = Window_MapName.prototype.open;
    Window_MapName.prototype.open = function ()
    {
        this.refresh();

        if ($gameSwitches.value(4))
        {
            this._showCount = 60;
        }
        else
        {
            if ($gameSwitches.value(65))
            {
                this._showCount = 150;
            }
        }
    };

    // 階数を付け加える
    var _Game_Map_displayName = Game_Map.prototype.displayName;

    Game_Map.prototype.displayName = function ()
    {
        if ($gameSwitches.value(4))
        {
            if ($dataMap.displayName)
            {
                return $dataMap.displayName + " " + $gameVariables.value(81) + "층";
            }
            else
            {
                return $dataMap.displayName;
            }
        }
        else
        {
            return $dataMap.displayName;
        }
    };
})();
